#include "g_local.h"
#include "ai_runt.h"

qboolean ClassItemEnabled (edict_t *ent, edict_t *item);
qboolean ClassItemEnabled2 (edict_t *ent, char *item);

void SP_cast_runt (edict_t *self);
void SP_cast_punk (edict_t *self);
void SP_cast_thug (edict_t *self);

void SP_cast_trader (edict_t *self);
void Menu_Trader (edict_t *ent);
void ED_CallSpawn (edict_t *ent);


static void MenuMain (edict_t *ent, entry_t *m);

extern voice_table_t pawnomatic_weapons_random [];
extern voice_table_t pawnomatic_sold[];
extern char *ep_names[];

// find the nearest trader!
edict_t *find_trader (edict_t *ent)
// returns pointer to power trader, or NULL if none found, and closes menu if open
{
	edict_t *find = NULL;

 
	while (find = findradius ( find, ent->s.origin, 80.0f ))
	{
		if (find == ent)
			continue;
		
		if (!directly_infront(ent, find))
			continue;
		
//CDEATH MODIFIED
//		if (!directly_infront(find, ent))
//			continue;
		
 
                                // trader found, return
		if ((Q_stricmp ("power_cast_trader", find->classname) == 0))// && (range(ent, find) == RANGE_MELEE))//Got to get real close before you can buy
			return find;
	}
	
	// reached here, no power traders found
                Menu_Close(ent);
	return NULL;
}




/*
Trader stuff
------------
Make this menu open on talking to the trader
All the prices are just to test
*/

//CDEATH
static void MenuBuyMod(edict_t *ent, entry_t *m)
{
	char ItemText[2];
	int Item;

	strncpy(ItemText, m->text, 1);
	ItemText[1] = 0;
	Item = atoi(ItemText);

	switch(Item)
	{
		case 1:
		{
			ent->client->pers.pistol_mods |= WEAPON_MOD_DAMAGE;
			break;
		}
		case 2:
		{
			ent->client->pers.pistol_mods |= WEAPON_MOD_ROF;
			break;
		}
		case 3:
		{
			ent->client->pers.pistol_mods |= WEAPON_MOD_RELOAD;
			break;
		}
		case 4:
		{
			ent->client->pers.pistol_mods |= WEAPON_MOD_COOLING_JACKET;
			break;
		}
	}
	ent->client->newweapon = ent->client->pers.weapon;
	ChangeWeapon(ent);
}
//END CDEATH

static void MenuBuyItem (edict_t *ent, entry_t *m)
{
	//	gi.dprintf("DEBUG: Item %s ammount %d\n", m->text+3, m->cost);
	gitem_t	*it;
	it = FindItem(m->text+3);
	
	if (it->flags & IT_WEAPON)
	{
		edict_t *trader = find_trader(ent);
		if (trader)
		{
			gi.cprintf( ent, PRINT_HIGH, "%s: Heres you weapon\n", trader->name);//CDEATH MODIFIED
			trader->cast_info.talk(trader);
		}
	}
	
	if (it->flags & IT_AMMO)
	{
		edict_t *trader = find_trader(ent);
		if (trader)
		{
			gi.cprintf( ent, PRINT_HIGH, "%s: Heres you ammo\n", trader->name);
			trader->cast_info.talk(trader);		Add_Ammo (ent, it, it->quantity);
		}
	}
	else
		ent->client->pers.inventory[ITEM_INDEX(it)]++;
	
	if (it->ammo)
	{
		gitem_t	*ammo = FindItem(it->ammo);
		Add_Ammo (ent, ammo, ammo->quantity);
	}
		
	Menu_Close(ent);
}
static void MenuClose (edict_t *ent, entry_t *m)
{
	edict_t *trader = find_trader(ent);
	if (trader)
	{
		gi.cprintf( ent, PRINT_HIGH, "%s: Peace,\n", trader->name);
		trader->cast_info.talk(trader);
	}
	Menu_Close(ent);
}

entry_t weapon2_purchase_menu[] = {
	{ "Purchase Weapons",		ALIGN_LEFT,		NULL,			0,		true },
	{ NULL,						ALIGN_LEFT,		NULL,			0,		true },
	{ "1. FlameThrower",		ALIGN_LEFT,		MenuBuyItem,	180,	true },
	{ "2. Heavy machinegun",	ALIGN_LEFT,		MenuBuyItem,	250,	true },
	{ "3. Grenade Launcher",	ALIGN_LEFT,		MenuBuyItem,	200,	true },
	{ "4. Bazooka",				ALIGN_LEFT,		MenuBuyItem,	250,	true },
	{ NULL,						ALIGN_LEFT,		NULL,			0,		true },
	{ "0. Back",				ALIGN_LEFT,		MenuMain,		0,		true },
	
};
static void MenuWeapon2 (edict_t *ent, entry_t *m)
{
	int i;
	// Do class enable/disables
	Menu_Close(ent);
	
	for (i = 2; i < 6; i++)
	{
		weapon2_purchase_menu[i].enabled = ClassItemEnabled2(ent, 
			weapon2_purchase_menu[i].text + 3);
	}
	
	Menu_Open(ent, weapon2_purchase_menu, sizeof(weapon2_purchase_menu)/sizeof(entry_t));
//CDEATH MODIFIED
	ent->client->showscores = SCORE_TRADER;
}
entry_t weapon1_purchase_menu[] = {
	{ "Purchase Weapons",	ALIGN_LEFT,		NULL,			0,		true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
	{ "1. Pipe",			ALIGN_LEFT,		MenuBuyItem,		10,		true },
	{ "2. Crowbar",			ALIGN_LEFT,		MenuBuyItem,		20,		true },
	{ "3. Pistol",			ALIGN_LEFT,		MenuBuyItem,		20,		true },
	{ "4. SPistol",			ALIGN_LEFT,		MenuBuyItem,		25,		true },
	{ "5. Shotgun",			ALIGN_LEFT,		MenuBuyItem,		75,		true },
	{ "6. Tommygun",		ALIGN_LEFT,		MenuBuyItem,		100,		true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,			true },
//CDEATH MODIFIED
	{ "0. Back",			ALIGN_LEFT,		MenuMain,			0,			true },
	
};
static void MenuWeapon1 (edict_t *ent, entry_t *m)
{
	int i;
	Menu_Close(ent);
	for (i = 2; i < 8; i++)
	{
		weapon1_purchase_menu[i].enabled = ClassItemEnabled2(ent, 
			weapon1_purchase_menu[i].text + 3);
	}
	Menu_Open(ent, weapon1_purchase_menu, sizeof(weapon1_purchase_menu)/sizeof(entry_t));
//CDEATH MODIFIED
	ent->client->showscores = SCORE_TRADER;
}
entry_t ammo_purchase_menu[] = {
	{ "Purchase Ammo",		ALIGN_LEFT,		NULL,			0,		true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
	{ "1. Bullets",			ALIGN_LEFT,		MenuBuyItem,		20,	true },
	{ "2. Shells",			ALIGN_LEFT,		MenuBuyItem,		30,	true },
	{ "3. Grenades",		ALIGN_LEFT,		MenuBuyItem,		50,	true },
	{ "4. Rockets",			ALIGN_LEFT,		MenuBuyItem,		75,	true },
	{ "5. 308cal",			ALIGN_LEFT,		MenuBuyItem,		90,	true },
	{ "6. Gas",				ALIGN_LEFT,		MenuBuyItem,		80,	true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
//CDEATH MODIFIED
	{ "0. Back",			ALIGN_LEFT,		MenuMain,			0,		true },
	
};

static void MenuAmmo (edict_t *ent, entry_t *m)
{
	//	int i;
	Menu_Close(ent);
	
	Menu_Open(ent, ammo_purchase_menu, sizeof(ammo_purchase_menu)/sizeof(entry_t));
//CDEATH MODIFIED
	ent->client->showscores = SCORE_TRADER;
}

//CDEATH
entry_t mod_purchase_menu[] = {
	{ "Purchase Mod",		ALIGN_LEFT,		NULL,				0,	true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,	true },
	{ "1. Pistol Power",	ALIGN_LEFT,		MenuBuyMod,			40,	true },
	{ "2. Pistol ROF",		ALIGN_LEFT,		MenuBuyMod,			80,	true },
	{ "3. Pistol Reload",	ALIGN_LEFT,		MenuBuyMod,			75, true },
	{ "4. HMG Cooling",		ALIGN_LEFT,		MenuBuyMod,			100,true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,	true },
//CDEATH MODIFIED
	{ "0. Back",			ALIGN_LEFT,		MenuMain,			0,	true },
	
};

static void MenuMods (edict_t *ent, entry_t *m)
{
	//	int i;
	Menu_Close(ent);
	
	Menu_Open(ent, mod_purchase_menu, sizeof(mod_purchase_menu)/sizeof(entry_t));
	ent->client->showscores = SCORE_TRADER;
}
//END CDEATH

static void MenuArmor (edict_t *ent, entry_t *m)
{
	gitem_t	*it;
	edict_t *trader = find_trader(ent);
	
	it = FindItem("Jacket Armor Heavy");
	ent->client->pers.inventory[ITEM_INDEX(it)] = ent->client->resp.class_ptr->armour;
	
	it = FindItem("Legs Armor Heavy");
	ent->client->pers.inventory[ITEM_INDEX(it)] = ent->client->resp.class_ptr->armour;
	
	it = FindItem("Helmet Armor Heavy");
	ent->client->pers.inventory[ITEM_INDEX(it)] = ent->client->resp.class_ptr->armour;
	
	if (trader)
	{
		gi.cprintf( ent, PRINT_HIGH, "%s: Heres your armour\n", trader->name);
		trader->cast_info.talk(trader);
	}
	ent->health = ent->max_health;
	Menu_Close(ent);
	
}

static void MenuHealth (edict_t *ent, entry_t *m)
{
	edict_t *trader = find_trader(ent);
	
	if (trader)
	{
		gi.cprintf( ent, PRINT_HIGH, "%s: That should patch you up\n", trader->name);
		trader->cast_info.talk(trader);
	}
	ent->health = ent->max_health;
	Menu_Close(ent);
}

entry_t trader_menu[] = {
	/*	Text					Align			Function			Cost	Enabled*/
//CDEATH MODIFIED
	{ "*Whats your Choice ?",	ALIGN_LEFT,		NULL,				0,		true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
	{ "1. Weapons 1",		ALIGN_LEFT,		MenuWeapon1,		0,		true },
	{ "2. Weapons 2",		ALIGN_LEFT,		MenuWeapon2,		0,		true },
	{ "3. Weapon Mods",		ALIGN_LEFT,		MenuMods,			0,		true },
	{ "4. Ammo",			ALIGN_LEFT,		MenuAmmo,			0,		true },
	{ "5. Armor",			ALIGN_LEFT,		MenuArmor,			300,	true },
	{ "6. Health",			ALIGN_LEFT,		MenuHealth,			100,	true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
//CDEATH MODIFIED
	{ "0. Exit",			ALIGN_LEFT,		MenuClose,			0,		true },
};

static void MenuMain (edict_t *ent, entry_t *m)
{
	Menu_Close(ent);
	Menu_Open(ent, trader_menu, sizeof(trader_menu)/sizeof(entry_t));
	ent->client->showscores = SCORE_TRADER;
}
void Menu_Trader (edict_t *ent)
{
	//	Menu_Close(ent);
	edict_t *trader = find_trader(ent);
	if (trader)
	{
		gi.cprintf( ent, PRINT_HIGH, "%s: What do you want to buy?\n", trader->name);
		trader->cast_info.talk(trader);
//CDEATH MODIFIED
//	}
	// Set health/armor cost for each class
		if (ent->health > 0)
		{
			Menu_Open(ent, trader_menu, sizeof(trader_menu)/sizeof(entry_t));
			ent->client->showscores = SCORE_TRADER;
		}			
	}
}

static char TraderName[] = {"Momo"};
static char TraderCast[] = {"power_cast_trader"};
static char TraderSkin[] = {"01w 01w 01w"};

void SP_cast_trader (edict_t *self)
{
	if (!self->name)
	{
//		self->name = malloc(10);
//		strcpy (self->name, "Momo");
//CDEATH MODIFIED
		self->name = TraderName;
	}
	self->cast_group = 0;
	self->classname = TraderCast;

	// make it so there can be any character as a trader
	self->cast_info.aiflags |= AI_IMMORTAL;
	self->art_skins = TraderSkin;
	SP_cast_thug(self);
}

void Cmd_testtrader_f (edict_t *ent)
{
	edict_t	*runt;	
	if (deathmatch->value && !sv_cheats->value)
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
	
	runt = G_Spawn();
	runt->classname = malloc(15);
	strcpy(runt->classname, "power_cast_trader");
	runt->think = SP_cast_trader;//SP_ControlPoint;
	runt->nextthink = level.time + 1;
	VectorCopy (ent->s.origin, runt->s.origin);
	
	gi.linkentity (runt);
}

qboolean TraderTalk(edict_t *self, edict_t *other)
{
	if (!stricmp(self->classname, "power_cast_trader"))
	{
		if (!other->client->resp.menu)
		{
			self->last_talk_time = level.time;// - TALK_SELF_DELAY)
			Menu_Trader(other);
		}
		return true;
	}
	return false;
	
}

//CDEATH ADDED
qboolean FacingTrader(edict_t* ent)
{
	edict_t *find = NULL;
 
	while (find = findradius( find, ent->s.origin, 150.0f ))//distance you have to step back before menu quit
	{
		if (find == ent)
			continue;
		if (!infront(ent, find))
			continue;
		if (Q_stricmp ("power_cast_trader", find->classname) == 0)
			return true;
	}
	return false;
}
